@ECHO OFF
:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: rsync_example.cmd - Batch file template for rsync
::
:: easy-smart solution GmbH
:: easy-smart.ch
:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:: Make environment script-local
SETLOCAL EnableDelayedExpansion
SET CWRSYNCHOME=.
:: Set CYGWIN variable to 'nontsec'. That makes sure that permissions
:: on your windows machine are not updated as a side effect of cygwin
:: operations.
SET CYGWIN=nontsec
:: Set HOME variable to your windows home directory. That makes sure 
:: that ssh command creates known_hosts in a directory you have access.
SET HOME=%HOMEDRIVE%%HOMEPATH%
:: Make cwRsync home as a part of system PATH to find required DLLs
SET CWOLDPATH=%PATH%
SET PATH=%CWRSYNCHOME%\bin;%PATH%
:: Setzt die TIMESTAMP im Format YYYY-MM-DD_HHMMSS
for /f %%f in ('c:\bin\date.exe +%%Y-%%m-%%d_%%H%%M%%S') do set TIMESTAMP=%%f
:: Setzt die UTIMESTAMP als unix timestamp
for /f %%f in ('c:\bin\date.exe +%%s') do set UTIMESTAMP=%%f
:: Set HOSTNAME variable to lower case host name
CALL bin\hostname.cmd

:: Windows paths may contain a colon (:) as a part of drive designation and 
:: backslashes (example c:\, g:\). However, in rsync syntax, a colon in a 
:: path means searching for a remote host. Solution: use absolute path 'a la unix', 
:: replace backslashes (\) with slashes (/) and put -/cygdrive/- in front of the 
:: drive letter:
:: 
:: Example : C:\WORK\* --> /cygdrive/c/work/*
:: 
:: Example 1 - rsync recursively to a unix server with an openssh server :
::
::       rsync -r /cygdrive/c/work/ remotehost:/home/user/work/
::
:: Example 2 - Local rsync recursively 
::
::       rsync -r /cygdrive/c/work/ /cygdrive/d/work/doc/
::
:: Example 3 - rsync to an rsync server recursively :
::    (Double colons?? YES!!)
::
::       rsync -r /cygdrive/c/doc/ remotehost::module/doc
::
:: Rsync is a very powerful tool. Please look at documentation for other options. 
::

:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Einstellungen fr das Backup
SET QUELLE="/cygdrive/d/rsync_example/"
SET BACKUPNAME=rsync_example

:: direct connection to rsync daemon
::SET ZIEL=rsync@10.200.1.16::Public/%BACKUPNAME%
:: local rsync
SET ZIEL="/cygdrive/e/rsync_example_destination/"
:: rsync over ssh
::SET ZIEL=rsync://onlinebackup.easy-smart.cloud/%BACKUPNAME%

::SET BWLIMIT="--bwlimit=45"
SET ZABBIXHOST=%HOSTNAME%_%BACKUPNAME%
SET ZABBIXSERVER=10.82.1.10
:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::



:: Find last timestamp(s) to continue incremental rsync
SET LAST_TIMESTAMP=%TIMESTAMP%
SET LASTBACKUPFILE="work\%BACKUPNAME%_lastbackup.txt"
IF NOT EXIST %LASTBACKUPFILE% ( type NUL > %LASTBACKUPFILE% )
for /f %%f in ('c:\bin\head.exe --lines=20 %LASTBACKUPFILE%') do SET LINKDEST=!LINKDEST! %%f

:: Set log file name and delete old log files
SET LOGFILE="--log-file=log/%TIMESTAMP%_%BACKUPNAME%.log"
c:\bin\find "log" -maxdepth 1 -type f -iname *_%BACKUPNAME%.log -daystart -ctime +10 -exec "c:\bin\rm \"{}\"" ;

:: Add timestamp to backup destination
SET ZIEL="%ZIEL%/%TIMESTAMP%"

:: Report start time to zabbix (Template "APP rsync")
echo Reporting to Zabbix Host %ZABBIXHOST%
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_laststart -o %UTIMESTAMP%
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_errorlevel -o 9999
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_errormsg -o "RUNNING"
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_statusmsg -o "Started %TIMESTAMP%"


:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: DO THE WORK!

:: dummy (wait 2 min)
c:\bin\sleep 120

:: direct connection to rsync daemon (ex. QNAP NAS)
::rsync --recursive --links --times --partial-dir=.rsync-partial --verbose --timeout=0 --progress --hard-links --delete --force --chmod u+rwx --stats %BWLIMIT% %LOGFILE% %LINKDEST% %QUELLE% %ZIEL% <pw.txt

:: local rsync (ex. to USB stick)
::rsync --recursive --links --times --partial-dir=.rsync-partial --verbose --timeout=900 --progress --hard-links --delete --force --chmod u+rwx --stats %LOGFILE% %LINKDEST% %QUELLE% %ZIEL%

:: rsync over ssh (ex. remote host)
::rsync -e "ssh -2 -o StrictHostKeyChecking=no -i work/rsync.key -l rsync" --recursive --links --times --partial-dir=.rsync-partial --verbose --timeout=900 --progress --hard-links --delete --force --compress --chmod u+rwx --stats %BWLIMIT% %LOGFILE% --link-dest=%LINKDEST% %QUELLE% %ZIEL%

:: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


:: Save error level and report end stats to zabbix
set ERRORLVL=%ERRORLEVEL%
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_errorlevel -o %ERRORLVL%
for /f "tokens=2 delims=|" %%f in ('c:\bin\grep -w %ERRORLVL% bin\errors.txt') do set ERRORMSG=%%f
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_errormsg -o "%ERRORMSG%"
:: Setzt die TIMESTAMPEND im Format YYYY-MM-DD_HHMMSS
for /f %%f in ('c:\bin\date.exe +%%Y-%%m-%%d_%%H%%M%%S') do set TIMESTAMPEND=%%f
:: Setzt die UTIMESTAMPEND als unix timestamp
for /f %%f in ('c:\bin\date.exe +%%s') do set UTIMESTAMPEND=%%f
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_lastfinish -o "%UTIMESTAMPEND%"
"%ProgramFiles%\zabbix\zabbix_sender" -z %ZABBIXSERVER% -s %ZABBIXHOST% -k rsync_statusmsg -o "Finished %TIMESTAMPEND%"


:: ERRORLEVEL > 0: Add timestamp of this run in front for next run's link-dest
:: ELSE: only store timestamp of this run
IF %ERRORLVL% GTR 0  ( c:\bin\mv %LASTBACKUPFILE% %LASTBACKUPFILE%.old )  ELSE  ( c:\bin\rm %LASTBACKUPFILE% )
c:\bin\printf.exe "--link-dest=../%%s\n" "%TIMESTAMP%" |c:\bin\cat >%LASTBACKUPFILE%
IF %ERRORLVL% GTR 0 (
	c:\bin\cat %LASTBACKUPFILE%.old >>%LASTBACKUPFILE%
	c:\bin\rm %LASTBACKUPFILE%.old
)
IF %ERRORLVL% EQU 0 ( echo COMPLETE >status/%TIMESTAMP%_%BACKUPNAME%.complete )
IF %ERRORLVL% GTR 0 ( echo ERROR_%ERRORLVL%_%ERRORMSG% >status/%TIMESTAMP%_%BACKUPNAME%.error )


:ENDE
EXIT /B %ERRORLVL%

