' Alle im Exchange eingetragenen E-Mail (=proxyAddress)
' Adressen in virtual.txt exportieren.
' Das File enthlt SQL-Statements fr MYSQL
'
' Roland Rusch, NCI-Systems AG
' $Id$
'
' Teile aus
' http://www.microsoft.com/windows2000/techinfo/ \
' planning/activedirectory/bulksteps.asp



'Globale Variablen
Dim Container
Dim OutPutFile
Dim FileSystem
Dim TableName
Dim FileName
Dim TmpFileName


'Globale Variablen initialisieren

'Hier muss der LDAP-Pfad fr den Start der Suche angegeben werden
Set Container=GetObject("LDAP://DC=int,DC=example,DC=com")
'Name der Tabelle in der neovis-Datenbank
TableName="tbl_PFlocal_recipients"
FileName="virtual.txt"
TmpFileName="virtual.tmp.txt"



'Weitere globale Variablen initialisieren
Set FileSystem = WScript.CreateObject("Scripting.FileSystemObject")
Set OutPutFile = FileSystem.CreateTextFile(TmpFileName, True)
OutPutFile.WriteLine "-- Adressen-Export aus Exchange"
OutPutFile.WriteLine "LOCK TABLES " & TableName & " WRITE;"



'Enumerate Container
EnumerateUsers Container

OutPutFile.WriteLine "UNLOCK TABLES;"
OutPutFile.WriteLine ""

'Clean up
OutPutFile.Close
FileSystem.CopyFile TmpFileName, FileName
Set FileSystem = Nothing
Set Container = Nothing

'Say Finished when your done
WScript.Echo "Finished"
WScript.Quit(0)


'Rekursive Funktion: Gibt die Empfnger auf der Datei aus
Sub EnumerateUsers(Cont)
Dim User

'Durch alle User im Container iiterieren
For Each User In Cont
Select Case LCase(User.Class)
	'fr Benutzer, Gruppen und ffentliche Ordner
	Case "user", "group", "publicfolder", "msexchdynamicdistributionlist", "contact"
		'Das Attribut proxyAddresses ausgeben
		Dim Alias, lalias
		If Not IsEmpty(User.proxyAddresses) Then
			If IsArray(User.proxyAddresses) Then
				'proxyAddresses ist ein Array -> mehrere Empfnger
				For Each Alias in User.proxyAddresses
					lalias=LCase(Alias)
					If StrComp(Left(lalias, 5), "smtp:", 0) = 0 Then
						'nur SMTP-Adressen
						OutPutFile.WriteLine "REPLACE INTO " & TableName & _
							" (recipient, lastupdate) VALUES ('" & _
							Replace(Mid(lalias, 6), "'", "\'") & _
							"', NOW());"
					End If
				Next
			Else
				'proxyAddresses ist kein Array -> nur 1 Empfnger
				Alias=User.proxyAddresses
				lalias=LCase(Alias)
				If StrComp(Left(lalias, 5), "smtp:", 0) = 0 Then
					'nur SMTP-Adressen
					OutPutFile.WriteLine "REPLACE INTO " & TableName & _
						" (recipient, lastupdate) VALUES ('" & _
						Replace(Mid(lalias, 6), "'", "\'") & _
						"', NOW());"
				End If
			End If
		End If

	'fr OUs, Container und Exchange-System-Container
	Case "organizationalunit" , "container", "msexchsystemobjectscontainer"
		'die Funktion rekursiv aufrufen und so die enthaltenen Adressen ausgeben
		EnumerateUsers User

End Select
Next
End Sub
