@ECHO OFF
:: $Id$

SET DSTPATH=\\192.168.30.60\public\Firmendaten
SET MAILTO=rr@nci.ch,helpdesk@nci.ch

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Setzt die TIMESTAMP im Format YYYY-MM-DD_HHMMSS
for /f %%f in ('c:\bin\date.exe +%%Y-%%m-%%d_%%H%%M%%S') do set TIMESTAMP=%%f

set LOGFILE=%CD%\tmp\%TIMESTAMP%.log
set CHECKFILE=%CD%\tmp\check_%TIMESTAMP%.txt

:: Logfile erstellen
echo %0 >%LOGFILE%
echo %TIMESTAMP% >>%LOGFILE%

:: Prfen, ob Zielverzeichnis vorhanden
IF NOT EXIST %DSTPATH%\. echo DSTPATH %DSTPATH% nicht gefunden >>%CHECKFILE% & GOTO FEHLER 

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

robocopy D:\Firmendaten\Daten %DSTPATH%\Daten /E /R:5 /W:5 /NP /TEE /LOG+:%LOGFILE%
if errorlevel 16 echo Daten:***FATAL ERROR*** >>%CHECKFILE%
if errorlevel 8  echo Daten:**FAILED COPIES** >>%CHECKFILE%
if errorlevel 4  echo Daten:*MISMATCHES* >>%CHECKFILE%

robocopy D:\Firmendaten\MAC %DSTPATH%\MAC /E /R:5 /W:5 /NP /TEE /LOG+:%LOGFILE%
if errorlevel 16 echo MAC:***FATAL ERROR*** >>%CHECKFILE%
if errorlevel 8  echo MAC:**FAILED COPIES** >>%CHECKFILE%
if errorlevel 4  echo MAC:*MISMATCHES* >>%CHECKFILE%

robocopy D:\Firmendaten\MegaCAD %DSTPATH%\MegaCAD /E /R:5 /W:5 /NP /TEE /LOG+:%LOGFILE%
if errorlevel 16 echo MegaCAD:***FATAL ERROR*** >>%CHECKFILE%
if errorlevel 8  echo MegaCAD:**FAILED COPIES** >>%CHECKFILE%
if errorlevel 4  echo MegaCAD:*MISMATCHES* >>%CHECKFILE%

robocopy D:\Firmendaten\Plotfiles %DSTPATH%\Plotfiles /E /R:5 /W:5 /NP /TEE /LOG+:%LOGFILE%
if errorlevel 16 echo Plotfiles:***FATAL ERROR*** >>%CHECKFILE%
if errorlevel 8  echo Plotfiles:**FAILED COPIES** >>%CHECKFILE%
if errorlevel 4  echo Plotfiles:*MISMATCHES* >>%CHECKFILE%

robocopy D:\Firmendaten\Programme %DSTPATH%\Programme /E /R:5 /W:5 /NP /TEE /LOG+:%LOGFILE%
if errorlevel 16 echo Programme:***FATAL ERROR*** >>%CHECKFILE%
if errorlevel 8  echo Programme:**FAILED COPIES** >>%CHECKFILE%
if errorlevel 4  echo Programme:*MISMATCHES* >>%CHECKFILE%



:: LOG-File kopieren
copy %LOGFILE% \\192.168.30.60\public\Firmendaten\BACKUPLOGS\
IF EXIST %CHECKFILE% GOTO FEHLER
GOTO ENDE


:FEHLER
ECHO FEHLER
mailsend -f administrator@obag.ch -d intern.obag.ch -smtp localhost -t %MAILTO% -sub "FEHLER: Tagessicherung 1 (copy2NAS)" -a %CHECKFILE% -a %LOGFILE%
EXIT /B 1


:ENDE
mailsend -f administrator@obag.ch -d intern.obag.ch -smtp localhost -t %MAILTO% -sub "ERFOLGREICH: Tagessicherung 1 (copy2NAS)" -a %LOGFILE%
DEL %LOGFILE%
EXIT /B 0