@echo off

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: DELOLD.BAT <generationen> <zielverzeichnis>                          ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Autor: Roland Rusch                                                  ::
:: $Id$
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Beschreibung:                                                        ::
:: Loescht alte Backups, die mit BACKUP.BAT erstellt wurden.            ::
:: Die in <generationen> spezifizierte Anzahl der neusten Sicherungen   ::
:: bleibt erhalten.
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::STARTTESTS::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: :: Kommandozeilen-Parameter an Variablen bernehmen mit voll
:: :: qualifiziertem Pfad
set GENERATIONEN=%1
set ZIEL=%~f2

:: :: Parameter berprfen
if "%GENERATIONEN%"=="" goto E_SYNTAX
if "%ZIEL%"=="" goto E_SYNTAX

:: :: Verzeichnisse berprfen
:: Ist das Zielverzeichnis vorhanden?
if NOT EXIST "%ZIEL%\." goto E_NOZIEL


::HAUPTROUTINE::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: :: Alte Verzeichnisse loeschen
:: Verzeichnisliste erstellen und sortieren
dir /b %ZIEL% | sort /r >$$$.tmp

:: Problem mit skip=0 abfangen
set FOROPTIONS="skip=%GENERATIONEN%"
if %GENERATIONEN%==0 set FOROPTIONS=

:: Anzahl Generationen ueberspringen, Loeschbefehl aufrufen
for /f %FOROPTIONS% %%A IN ($$$.tmp) DO set DELDIR=%ZIEL%\%%A & CALL :DELETEME


::CLEANUP:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Temporaere Datei loeschen
del $$$.tmp

:: :: Skript beenden
goto :EOF
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::SUBROUTINEN:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:DELETEME
echo Deleting %DELDIR%
del %DELDIR%
goto :EOF


::FEHLERMELDUNGEN:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: :: Die Syntax fr den Aufruf ist falsch
:E_SYNTAX
echo.
echo Syntax: %0 ^<generationen^> ^<zielverzeichnis^>
echo.
goto :EOF

:: :: Das Zielverzeichnis ist nicht vorhanden
:E_NOZIEL
echo Das Zielverzeichnis (%ZIEL%) ist nicht vorhanden
goto :EOF


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: ENDE VON DELOLD.BAT                                                  ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

